define(['app', 'angular'], function (app, angular) {

	app.directive('inputPhone', function ($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngModel': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngReadonly': '=',
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				//validation
				var validationPattern = /^\(\d{3}\) \d{3}\-\d{4}$/;

                var validator = function(newVal) {
                	ngModelCtrl.$setValidity("pattern", !newVal || validationPattern.test(newVal));
					return newVal;
                };

                ngModelCtrl.$parsers.push(validator);
                ngModelCtrl.$formatters.push(validator);

				var label = scope.label && scope.label.replace(/:/, '').trim();

				scope.errorHandling = {
					'required': {
						message: label + ' field is required.',
						priority: 1
					},
					'pattern' : {
						message: label + ' must be formatted (###) ###-####.',
						priority: 2
					}
				};

			},
			templateUrl: 'src/ui-components/form/controls/simple/input-phone/input-phone_template.html'
		};
	});

});